var requestString = "";
var idArray = [];

var requestStringHeader = "";
var idArrayHeader = [];
var requestStringMain = "";
var idArrayMain = [];

var nScreenId = 0;
var nStreamHash = 0;

var nStreamId = 0;

// edit modes :-
// 0 = none
// -1 = time
// -2 = date
// -3 = double / int value
// -4, -5 = dhcp 0/1
// -6, -7 = ip address 0/1
// -8, -9 = netmask 0/1
// -10, -11 = gateway 0/1
// -12 = accept changes
// -13 = date format
// -14 = time offset
// -60..63 = reboot (warm, clear, keep, default)
// -70 = printer transport
// -71 = printer address
// -72 = printer port
// -73 = printer flow control mode
// -140 = report archive
// -205 = reset profile data
// -207 = edit digouts
// -900 = edit username
// -901 = edit password
// -902 = edit level
// -903 = add user (name)
// -904 = add user (password)
// -905 = add user (password confirm)
// -906 = add user (level)
// -907 = delete user
// -908 = confirm password
// -998 = login (waiting for current user to logout)
// -999 = login

var EDIT_MODE_NONE = 0;
var EDIT_MODE_TIME = -1;
var EDIT_MODE_DATE = -2;
var EDIT_MODE_VALUE = -3;
var EDIT_MODE_DHCP0 = -4;
var EDIT_MODE_DHCP1 = -5;
var EDIT_MODE_IPADDR0 = -6;
var EDIT_MODE_IPADDR1 = -7;
var EDIT_MODE_NETMASK0 = -8;
var EDIT_MODE_NETMASK1 = -9;
var EDIT_MODE_GATEWAY0 = -10;
var EDIT_MODE_GATEWAY1 = -11;
var EDIT_MODE_ACCEPT = -12;
var EDIT_MODE_DATE_FORMAT = -13;
var EDIT_MODE_TIME_OFFSET = -14;
var EDIT_MODE_REBOOT_WARM = -60;
var EDIT_MODE_REBOOT_CLEAR = -61;
var EDIT_MODE_REBOOT_KEEP = -62;
var EDIT_MODE_REBOOT_DEFAULT = -63;
var EDIT_MODE_PRINTER_TRANSPORT = -70;
var EDIT_MODE_PRINTER_ADDR = -71;
var EDIT_MODE_PRINTER_PORT = -72;
var EDIT_MODE_PRINTER_FLOW = -73;
var EDIT_MODE_ARCHIVE = -140;
var EDIT_MODE_RESET_PROFILE = -205;
var EDIT_MODE_DIGOUTS = -207;

var EDIT_MODE_IP = -800;

var EDIT_MODE_USER_NAME = -900;
var EDIT_MODE_USER_PWD = -901;
var EDIT_MODE_USER_LEVEL = -902;
var EDIT_MODE_USERADD_NAME = -903;
var EDIT_MODE_USERADD_PWD = -904;
var EDIT_MODE_USERADD_PWD2 = -905;
var EDIT_MODE_USERADD_LEVEL = -906;
var EDIT_MODE_USER_DELETE = -907;
var EDIT_MODE_USER_PWD2 = -908;
var EDIT_MODE_FNKEY = -950;
var EDIT_MODE_LOGGED_IN = -998;
var EDIT_MODE_LOGIN = -999;

var SCREEN_TYPE_PREVIEW = -90;
var SCREEN_TYPE_USERS = -95;
var SCREEN_TYPE_ALARMS = -99;
var SCREEN_TYPE_LOGOUT = -130;

var CONST_SYSINFO_POOL = 4;

var nEditMode = EDIT_MODE_NONE;
var bHaveMinus;
var bHaveExp;
var bHavePoint;
var bEditDouble;
var EditText;
var NewUserName;
var NewPassword;

var NewDhcp = ['', ''];
var NewAddress = ['', ''];
var NewNetmask = ['', ''];
var NewGateway = ['', ''];

var nTimeIndex;
var nTimeData = [0, 0, 0];
var nTimeCursorOffset = [11, 46, 82];
var nTimeOffsetCursorOffset = [21, 56];
var nDateIndex;
var nDateData = [0, 0, 0];	// day, month, year
var nDayIndex;
var nMonthIndex;
var nYearIndex;
var nDateCursorOffset = [0, 0, 0];

var nIpByte;
var nIpByteIndex;

var flashId;
var cursorOffset = 2;

var bAlarmFlashing = false;
var flashAlarmId = -1;

var timerId;

var clickActive = false;
var clickId;

var LoginX, LoginY;
var LoginId;
var LoginTimeout;
var doLogout = false;

var bGotTimeout = false;
var bGotReply = false;

var bPreview = false;

var setFnKeyIndex;
var FNKEY_CHARS = 20;
var setFnKeyText = '';

var listCount;
var listIndex = 0;
var listTop = 0;
var listHeight = 0;
var itemHeight = 0;
var maxVisible = 0;
var firstVisible = -1;
var lastVisible = -1;

var listTableCount;
var listTableIndex = 0;
var firstTableVisible = -1;
var lastTableVisible = -1;

var nListHash = -1;
var nHeaderHash = -1;

var nSpoolHash = 0;

var adcLowValue;
var adcLowValueLive;
var adcHighValue;
var adcHighValueLive;

var NFBSYSINFO_NET_IP1 = 4;
var NFBSYSINFO_NET_IP2 = 5;
var NFBSYSINFO_NET_DHCP1 = 100;
var NFBSYSINFO_NET_DHCP2 = 105;
var NFBSYSINFO_NET_NETMASK1 = 114;
var NFBSYSINFO_NET_NETMASK2 = 117;
var NFBSYSINFO_NET_GATEWAY1 = 120;
var NFBSYSINFO_NET_ACCEPT = 124;

var NFBSYSINFO_FTP_TEST = 228;

var NFBSYSINFO_PRINTER1_TRANSPORT = 300;
var NFBSYSINFO_PRINTER2_TRANSPORT = 320;
var NFBSYSINFO_PRINTER3_TRANSPORT = 340;

var NFBSYSINFO_HOSTNAME = 150;

// screen ids copied from nanoweb.cpp
var SYSTEM_SHOW_ALARMS = 510;

var SYSTEM_SHOW_METROLOGY_EVENT_LOG = 532;

var SYSTEM_SHOW_SPOOL = 604;

var SYSTEM_SHOW_INFO_ADCS1 = 716;

var SYSTEM_SHOW_USER_ADD = 720;
var SYSTEM_SHOW_USER_DELETE = 721;
var SYSTEM_SHOW_USER_EDIT_NAME = 722;
var SYSTEM_SHOW_USER_EDIT_PWD = 723;
var SYSTEM_SHOW_USER_EDIT_LEVEL = 724;

var NFBSYSINFO_NET_PORTS_START = 800;

var ALARM_ID_PRINTER1_ERROR		= (1 << 0);
var ALARM_ID_SPOOL_FULL			= (1 << 1);
var ALARM_ID_IO_COMMS_FAIL		= (1 << 2);
var ALARM_ID_TASK_FAIL			= (1 << 3);
var ALARM_ID_INVALID_APP		= (1 << 4);
var ALARM_ID_RAM_FAIL			= (1 << 5);
var ALARM_ID_FLASH_FAIL			= (1 << 6);
var ALARM_ID_FRAM_FAIL			= (1 << 7);
var ALARM_ID_WATCHDOG			= (1 << 8);
var ALARM_ID_ETH1_FAIL			= (1 << 9);
var ALARM_ID_ETH2_FAIL			= (1 << 10);
var ALARM_ID_SDCARD_ERROR		= (1 << 11);
var ALARM_ID_PRINTER2_ERROR		= (1 << 12);
var ALARM_ID_PRINTER3_ERROR		= (1 << 13);

var ALARM_ID_ALL_PRINTERS		= ALARM_ID_PRINTER1_ERROR | ALARM_ID_PRINTER2_ERROR | ALARM_ID_PRINTER3_ERROR | ALARM_ID_SDCARD_ERROR;

if (!Array.prototype.indexOf) {
	Array.prototype.indexOf = function (searchElement, fromIndex) {
		if ( this === undefined || this === null ) {
			throw new TypeError( '"this" is null or not defined' );
		}

		var length = this.length >>> 0; // Hack to convert object.length to a UInt32

		fromIndex = +fromIndex || 0;

		if (Math.abs(fromIndex) === Infinity) {
			fromIndex = 0;
		}

		if (fromIndex < 0) {
			fromIndex += length;
			if (fromIndex < 0) {
				fromIndex = 0;
			}
		}

		for (;fromIndex < length; fromIndex++) {
			if (this[fromIndex] === searchElement) {
				return fromIndex;
			}
		}

		return -1;
	};
}

function getCookie(cname)
{
	var name = cname + "=";
	var decodedCookie = decodeURIComponent(document.cookie);
	var ca = decodedCookie.split(';');
	for (var i = 0; i <ca.length; i++)
	{
		var c = ca[i];
		while (c.charAt(0) == ' ')
			c = c.substring(1);
		if (c.indexOf(name) == 0)
			return c.substring(name.length, c.length);
	}
	return "";
}

////////////////////////////////////////////////////////////////////////////////

// routine to encode url strings
var hexArray = ['0','1','2','3','4','5','6','7','8','9','a','b','c','d','e','f'];
function urlEncode(s)
{
	var t = '';
	
	for (var i = 0; i < s.length; i++)
	{
		var c = s.charAt(i);
		// do we have a 'reserved' character ?
		//if ("!*'();:@&=+$,/?#[]% ".indexOf(c) != -1)
		if ("!*'();@&=+$,?#[]% ".indexOf(c) != -1)
		{
			var code = s.charCodeAt(i);
			t += '%' + hexArray[(code / 16) >> 0] + hexArray[code % 16];
		}
		else
			t += c;
	}

	return t;
}

////////////////////////////////////////////////////////////////////////////////

// routinet to reset logout timeout
function resetTimeout()
{
	clearInterval(LoginTimeout);
	if (nLogoutInterval != 0)
		LoginTimeout = setTimeout("logout()", nLogoutInterval);

	clearInterval(timerInterval);
}

var timerValue;
var timerInterval;
var timerCallback;
function updateTimer()
{
	var mc = document.getElementById('modalcontainer');
	if (mc === null)
	{
		timerCallback();
		return;
	}
	mc.innerHTML = "<div id=\"timeout\">" + langStrings.STRING_IDENT_NETWORK_RESTART + " : " + --timerValue + "</div>";

	if (timerValue <= 0)
	{
		clearInterval(timerInterval);
		timerCallback();
		return;
	}
}

function showTimer(sec, callback)
{
	var mw = document.getElementById('modalwrapper');
	var mc = document.getElementById('modalcontainer');
	if ((mw === null) || (mc === null))
	{
		callback();
		return;
	}

	mw.style.height = '5em';
	mc.innerHTML = "<div id=\"timeout\">" + langStrings.STRING_IDENT_NETWORK_RESTART + " : " + sec + "</div>";

	showEdit();

	timerValue = sec;
	timerCallback = callback;
	timerInterval = setInterval("updateTimer()", 1000);
}
////////////////////////////////////////////////////////////////////////////////

var editDomId;
var editPinId;
var editType;
var tableElement;

var MAX_INT = 2147483647;
var MIN_INT = -2147483648;
var MAX_DOUBLE_LEN = 18;
var MAX_INTEGER_LEN = 11;

// check keypresses depending on edit mode
function keyPress(self, evt, type)
{
	resetTimeout();
	
	var charCode = evt.which || evt.charCode;
	var keyCode = evt.keyCode;
	//console.log(charCode, keyCode);

	// handle copy & paste
	if (evt.ctrlKey && ((charCode === 99) || (charCode === 118)))
		return true;

	if (keyCode === 8) return true;	// backspace
	if (keyCode === 9)		// tab
	{
		if (evt.shiftKey)
		{
			if (type == 'Username')
				document.getElementById('newpwd2').focus();
			else if (type == 'Userlevel')
				document.getElementById('newname').focus();
			else if (type == 'Password')
				document.getElementById('newlevel').focus();
			else if (type == 'Password2')
				document.getElementById('newpwd').focus();
			return false;
		}
		else
		{
			if (type == 'Username')
				document.getElementById('newlevel').focus();
			else if (type == 'Userlevel')
				document.getElementById('newpwd').focus();
			else if (type == 'Password')
				document.getElementById('newpwd2').focus();
			else if (type == 'Password2')
				document.getElementById('newname').focus();
			return false;
		}

		return true;
	}
	if (keyCode === 13)	// enter
	{
		switch (editType)
		{
		case 'userAdd':
		case 'userEdit':
			closeUser();
			break;
		default:
			closeValue();
			break;
		}
	}
	if (keyCode === 27) closeEdit();	// escape
	if ((keyCode >= 35) && (keyCode <= 40)) return true;	// home, end, cursor keys

	// if string edit, accept everything but don't allow empty strings
	if ((type == 'StringF') || (type == 'String'))
	{
		if ((charCode == 32) && (self.value.trim().length == 0)) return false;
		return true;
	}

	// if number, check length
	if ((type == 'NumberD') && (self.value.length >= MAX_DOUBLE_LEN)) return false;
	if ((type == 'NumberI') && (self.value.length >= MAX_INTEGER_LEN)) return false;		

	if ((charCode >= 48) && (charCode <= 57)) return true;	// digits

	// if date edit, accept '/' and nothing else
	if (type == 'Date')
	{
		if (charCode === 47) return true;	// '/'
		return false;
	}

	// if time edit, accept ':' and nothing else
	if (type == 'Time')
	{
		if (charCode === 58) return true;	// ':'
		return false;
	}

	// if time offset edit, accept '+', '-', ':'  and nothing else
	if (type == 'TimeOffset')
	{
		if (charCode === 43) return true;	// '+'
		if (charCode === 45) return true;	// '-'
		if (charCode === 58) return true;	// ':'
		return false;
	}

	// if hostname accept '-' and alphas and nothing else
	if (type == 'Hostname')
	{
		if (charCode === 45) return true;	// '-'
		if ((charCode >= 65) && (charCode <= 90)) return true;	// uppercase alphas
		if ((charCode >= 97) && (charCode <= 122)) return true;	// lowercase alphas
		return false;
	}

	// if username edit, accept [a-zA-Z0-9_-.]
	if (type === 'Username')
	{
		if (charCode === 45) return true;	// '-'
		if (charCode === 46) return true;	// '.'
		if ((charCode >= 65) && (charCode <= 90)) return true;	// uppercase alphas
		if (charCode === 95) return true;	// '_'
		if ((charCode >= 97) && (charCode <= 122)) return true;	// lowercase alphas
		return false;
	}

	// if password edit, accept only standard visible ASCII
	if ((type == 'Password') || (type == 'Password2'))
	{
		var e = evt || window.event;
		var c = e.charCode;
		return ((c >= 32) || (c <= 127));
	}

	// decimal separator not valid for integers
	if (charCode === DECIMAL_SEPARATOR) return (type != 'NumberI');	// '.'

	// if ip edit, reject everything else
	if (type == 'IP') return false;

	// other keys needed for number edit
	if (charCode === 45) return true;	// '-'
	if (charCode === 69) return true;	// 'E'
	if (charCode === 101) return true;	// 'e'

	return false;
}

// check for valid number
function validNumber(self, isInteger, button)
{
	// convert decimal separator
	var val = self.value;
	val = val.replace(String.fromCharCode(DECIMAL_SEPARATOR), ".");

	// is this a valid number ?
	var isValid = (val.length > 0) && (!isNaN(val * 1));
	if (isValid && isInteger)
	{
		var n = val;
		isValid = ((n == Math.round(n)) && (n <= MAX_INT) && (n >= MIN_INT));
	}
	self.style.color = isValid ? 'green' : 'red';

	if (button !== undefined)
		button.className = isValid ? 'editaccept' : 'editacceptgrey';

	return isValid;
}

// check for valid ip address
function validIP(self, button)
{
	//regex. check for digits and in all 4 quadrants of the IP
	var re = /^(([01]?\d\d?|2[0-4]\d|25[0-5])\.){3}([01]?\d\d?|25[0-5]|2[0-4]\d)$/;

	// is this a valid ip address ?
    var isValid = re.test(self.value);
	self.style.color = isValid ? 'green' : 'red';

	if (button !== undefined)
		button.className = isValid ? 'editaccept' : 'editacceptgrey';

	return isValid;
}

// check for valid date
function validDate(self, button, format)
{
	var isValid = false;

	// chose supported regex
	var re;
	var relen;
	if (format === 'YYYY/MM/DD')
	{
		re = /^(\d{4})\/(\d{1,2})\/(\d{1,2})$/;
		relen = 4;
	}
	else if ((format === 'DD/MM/YYYY') || (format === 'MM/DD/YYYY'))
	{
		re = /^(\d{1,2})\/(\d{1,2})\/(\d{4})$/;
		relen = 4;
	}
	else if ((format === 'MM/DD') || (format === 'DD/MM'))
	{
		re = /^(\d{1,2})\/(\d{1,2})$/;
		relen = 3;
	}
	else
		return false;

   	// check hour, minute, second values
   	var values = self.value.match(re);
	if ((values !== null) && (values.length === relen))
	{
		var yyyy, mm, dd;

		if (format === 'YYYY/MM/DD')
		{
			yyyy = parseInt(values[1], 10);
			mm = parseInt(values[2], 10);
			dd = parseInt(values[3], 10);
		}
		else if (format === 'DD/MM/YYYY')
		{
			yyyy = parseInt(values[3], 10);
			mm = parseInt(values[2], 10);
			dd = parseInt(values[1], 10);
		}
		else if (format === 'MM/DD/YYYY')
		{
			yyyy = parseInt(values[3], 10);
			mm = parseInt(values[1], 10);
			dd = parseInt(values[2], 10);
		}
		else if (format === 'MM/DD')
		{
			yyyy = 2010;
			mm = parseInt(values[1], 10);
			dd = parseInt(values[2], 10);
		}
		else if (format === 'DD/MM')
		{
			yyyy = 2010;
			mm = parseInt(values[2], 10);
			dd = parseInt(values[1], 10);
		}
		isValid = (yyyy >= 2010) && (yyyy <= 2077) && (mm >= 1) && (mm <= 12) && (dd >= 1) && (dd <= 31);
		if (isValid)
		{
			var days = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
			if (dd > days[mm - 1])
				isValid = false;
		}
	}

	self.style.color = isValid ? 'green' : 'red';

	if (button !== undefined)
		button.className = isValid ? 'editaccept' : 'editacceptgrey';

	return isValid;
}

// check for valid time
function validTime(self, button)
{
	var isValid = false;

	//regex. check for hh:mm:ss
	var re = /^(\d{2}):(\d{2}):(\d{2})$/;

   	// check hour, minute, second values
   	var values = self.value.match(re);
	if ((values !== null) && (values.length === 4))
	{
		var hh = parseInt(values[1], 10);
		var mm = parseInt(values[2], 10);
		var ss = parseInt(values[3], 10);
		isValid = (hh >= 0) && (hh <= 23) && (mm >= 0) && (mm <= 59) && (ss >= 0) && (ss <= 59);
	}

	self.style.color = isValid ? 'green' : 'red';

	if (button !== undefined)
		button.className = isValid ? 'editaccept' : 'editacceptgrey';

	return isValid;
}

// check for valid time offset
function validTimeOffset(self, button)
{
	var offset = NaN;
	var isValid = false;

	//regex. check for +hh:mm
	var re = /^([+-]?)(\d\d?)(:\d\d?)?$/;

   	// check hour, minute values
   	var values = self.value.match(re);
	if (values !== null)
	{
		var hh = parseInt(values[2], 10);
		var mm = 0;
		if (values[3] !== undefined)
			mm = parseInt(values[3].substring(1,3), 10);
		isValid = (hh >= 0) && (hh <= 23) && (mm >= 0) && (mm <= 59);
		if (isValid)
		{
			offset = (hh * 60) + mm;
			if (values[1].charAt(0) === '-')
				offset *= -1;
		}
	}

	self.style.color = isValid ? 'green' : 'red';

	if (button !== undefined)
		button.className = isValid ? 'editaccept' : 'editacceptgrey';

	return offset;
}

// check for valid hostname
function validHostname(self, button)
{
	var isValid = false;

	if (self.value.length < 63)
	{
		//regex. check for hostname
		var re = /^[a-zA-Z0-9]([a-zA-Z0-9-]*)[a-zA-Z0-9]$/;

	   	// check hour, minute, second values
	   	var values = self.value.match(re);
		isValid = (values !== null);
	}

	self.style.color = isValid ? 'green' : 'red';

	if (button !== undefined)
		button.className = isValid ? 'editaccept' : 'editacceptgrey';

	return isValid;
}

// check for valid user
function validUser(self, button)
{
	// check username
	var ne = document.getElementById('newname');
	var neValid = (ne.value.length > 0);
	if (neValid)
	{
		// check if username already used
		var index = 0;
		var one = document.getElementById('u' + index + 'n');
		while (one)
		{
			if ((ne.value == one.innerHTML) && ('u'.concat(index) != editPinId))
			{
				neValid = false;
				break;
			}
			index++;
			one = document.getElementById('u' + index + 'n');
		}
		var unle = document.getElementById('usernamel');
		if (neValid)
		{
			unle.innerHTML = langStrings.STRING_IDENT_USERNAME + ' :';
			unle.style.color = '#246BB2';
		}
		else
		{
			unle.innerHTML = langStrings.STRING_IDENT_USERNAME_ALREADY_IN_USE;
			unle.style.color = '#CC0000';
		}
	}
	ne.style.color = neValid ? 'green' : 'red';

	// check passwords
	var pe = document.getElementById('newpwd');
	var pe2 = document.getElementById('newpwd2');
	var peValid;
	if (editType === 'userAdd')
		peValid = ((pe.value.length > 0) && (pe2.value.length > 0) && (pe.value === pe2.value));
	else if (editType === 'userEdit')
		peValid = (((pe.value.length == 0) && (pe2.value.length == 0)) ||
					((pe.value.length > 0) && (pe2.value.length > 0) && (pe.value === pe2.value)));
	var pwle = document.getElementById('passwordl');
	if (pe.value === pe2.value)
	{
		pwle.innerHTML = langStrings.STRING_IDENT_CONFIRM_PASSWORD + ' :';
		pwle.style.color = '#246BB2';
	}
	else
	{
		pwle.innerHTML = langStrings.STRING_IDENT_PASSWORDS_DO_NOT_MATCH;
		pwle.style.color = '#CC0000';
	}
	pe.style.color = pe2.style.color = peValid ? 'green' : 'red';

	var isValid = (neValid && peValid);

	if (button !== undefined)
		button.className = isValid ? 'editaccept' : 'editacceptgrey';

	return isValid;
}

// check for valid string
function validString(self, allowempty, button)
{
	var isValid = true;

	if ((allowempty == false) && (self.value.trim().length == 0)) isValid = false;

	self.style.color = isValid ? 'green' : 'red';

	if (button !== undefined)
		button.className = isValid ? 'editaccept' : 'editacceptgrey';

	return isValid;
}

// show modal edit window
function showEdit()
{
	// trap text highlighting
	if (isTextHighlighted())
		return;

	resetTimeout();
	
	var mo = document.getElementById('modaloverlay');
	var mw = document.getElementById('modalwrapper');
	mo.style.zIndex = 1001;
	mw.style.zIndex = 1002;
	mo.style.visibility = 'visible';
	mw.style.visibility = 'visible';
	document.body.style.cursor = 'wait';
}

// close modal edit window
function closeEdit()
{
	// trap text highlighting
	if (isTextHighlighted())
		return;

	resetTimeout();
	
	var mo = document.getElementById('modaloverlay');
	var mw = document.getElementById('modalwrapper');
	mo.style.zIndex = -1;
	mw.style.zIndex = -1;
	mo.style.visibility = 'hidden';
	mw.style.visibility = 'hidden';
	document.body.style.cursor = 'default';
	nEditMode = EDIT_MODE_NONE;
}

// routint to check for text highlighting
function isTextHighlighted()
{
	// trap text highlighting
	var txtSelect = window.getSelection().toString()
	if ((txtSelect != "") && (txtSelect != "\n"))
		return true;

	return false;
}

// create modal string edit
function editString(domId, pinId, type, itemName)
{
	// trap text highlighting
	if (isTextHighlighted())
		return;

	editDomId = domId;
	editPinId = pinId;
	editType = type;

	var mw = document.getElementById('modalwrapper');
	var mc = document.getElementById('modalcontainer');
	if ((mw === null) || (mc === null))
		return;

	if (type == 'ADCConfirm')
		mw.style.height = '12.75em';
	else
		mw.style.height = '14.5em';

	// if the item name has not been specified, look it up
	if (itemName === undefined)
	{
		var elName = document.getElementById(domId + 'n');
		if (elName !== null)
			itemName = elName.innerHTML;
	}

	mc.innerHTML = "<div id=\"editheader2\"/>";
	var eh2 = document.getElementById('editheader2');
	switch (type)
	{
	case 'ADCLow':
		nEditMode = SYSTEM_SHOW_INFO_ADCS1;
		eh2.innerHTML += "<p class=\"edittitle\">" + langStrings.STRING_IDENT_ENTER_LOW_SCALE + " ...</p>";
		break;
	case 'ADCHigh':
		nEditMode = SYSTEM_SHOW_INFO_ADCS1;
		eh2.innerHTML += "<p class=\"edittitle\">" + langStrings.STRING_IDENT_ENTER_HIGH_SCALE + " ...</p>";
		break;
	case 'ADCConfirm':
		eh2.innerHTML += "<p class=\"edittitle\">" + langStrings.STRING_IDENT_CONFIRM_SCALING + " ...</p>";
		break;
	default:
		eh2.innerHTML += "<p class=\"edittitle\">" + langStrings.STRING_IDENT_EDIT_VALUE + " ...</p>";
		break;
	}
	mc.innerHTML += "<div id=\"editheader\"/>";
	var eh = document.getElementById('editheader');
	if (type == 'ADCConfirm')
	{
		eh.style.height = '5.75em';
		eh.innerHTML += "<p class=\"editnamel\">" + langStrings.STRING_IDENT_ITEM_NAME + " :</p><p class=\"editname\">" + itemName + "</p>";
		eh.innerHTML += "<p class=\"editvaluel\">" + langStrings.STRING_IDENT_LOW_SCALE + " :</p><p class=\"editvalue\">" + adcLowValue + " @ " + adcLowValueLive + "</p>";
		eh.innerHTML += "<p class=\"editvaluel\">" + langStrings.STRING_IDENT_HIGH_SCALE + " :</p><p class=\"editvalue\">" + adcHighValue + " @ " + adcHighValueLive + "</p>";
	}
	else
	{
		if (itemName !== undefined)
			eh.innerHTML += "<p class=\"editnamel\">" + langStrings.STRING_IDENT_ITEM_NAME + " :</p><p class=\"editname\">" + itemName + "</p>";
		var itemValueEl = document.getElementById(domId + 'v');
		if (itemValueEl !== null)
		{
			var v = itemValueEl.innerHTML;
			switch (nEditMode)
			{
			case SYSTEM_SHOW_INFO_ADCS1:
				v = getLiveADCValue(v);
				break;
			}
			eh.innerHTML += "<p class=\"editvaluel\">" + langStrings.STRING_IDENT_CURRENT_VALUE + " :</p><p id=\"editvalue\" class=\"editvalue\">" + v + "</p>";
		}

		mc.innerHTML += " <div id=\"editstring\" class=\"editstring\"/>\n";
		var mf = document.getElementById('editstring');

		if (type == 'Password')
		{
			mf.innerHTML += "<p><input id=\"textbox\" type=\"password\"/></p>";
			editType = type = 'String';
		}
		else if (type == 'PasswordF')
		{
			mf.innerHTML += "<p><input id=\"textbox\" type=\"password\"/></p>";
			editType = type = 'StringF';
		}
		else
			mf.innerHTML += "<p><input id=\"textbox\" type=\"text\"/></p>";
	}

	mc.innerHTML += "<div id=\"editfooter\"/>\n";
	var ef = document.getElementById('editfooter');
	switch (type)
	{
	case 'String':
		ef.innerHTML += "<div id=\"accept\" class=\"editaccept\"><a onClick=\"closeValue();\">" + langStrings.STRING_IDENT_APPLY + "</a></div>\n";
		break;
	case 'NumberD':
	case 'NumberI':
	case 'IP':
	case 'Time':
	case 'Date':
	case 'TimeOffset':
	case 'Hostname':
	case 'StringF':
		ef.innerHTML += "<div id=\"accept\" class=\"editacceptgrey\"><a onClick=\"closeValue();\">" + langStrings.STRING_IDENT_APPLY + "</a></div>\n";
		break;
	case 'ADCLow':
		ef.innerHTML += "<div id=\"accept\" class=\"editacceptgrey\"><a onClick=\"closeValue();\">" + langStrings.STRING_IDENT_SET_LOW_SCALE + "</a></div>\n";
		ef.innerHTML += "<div class=\"editdefault\"><a onClick=\"editConfirm('" + editPinId + "', 'resetADC', '" + langStrings.STRING_IDENT_RESET_SCALE_TO_DEFAULT + "');\">Default</a></div>\n";
		break;
	case 'ADCHigh':
		ef.innerHTML += "<div id=\"accept\" class=\"editacceptgrey\"><a onClick=\"closeValue();\">" + langStrings.STRING_IDENT_SET_HIGH_SCALE + "</a></div>\n";
		break;
	case 'ADCConfirm':
		ef.innerHTML += "<div id=\"accept\" class=\"editaccept\"><a onClick=\"closeADC();\">" + langStrings.STRING_IDENT_CONFIRM + "</a></div>\n";
		ef.style.paddingTop = '0.25em';
		break;
	}
	switch (type)
	{
	case 'ADCLow':
	case 'ADCHigh':
	case 'ADCConfirm':
		ef.innerHTML += "<div class=\"editcancel\"><a onClick=\"setCalMode('" + editPinId + "', 0);closeEdit();\">" + langStrings.STRING_IDENT_CANCEL + "</a></div>\n";
		break;
	default:
		ef.innerHTML += "<div class=\"editcancel\"><a onClick=\"closeEdit();\">" + langStrings.STRING_IDENT_CANCEL + "</a></div>\n";
		break;
	}

	showEdit();

	var tb = document.getElementById('textbox');
	if (tb !== null)
		tb.focus();
}

// validate edit string
function closeValue()
{
	// trap text highlighting
	if (isTextHighlighted())
		return;

	var es = document.getElementById('textbox');
	var value = es ? es.value : '';
	switch (editType)
	{
	case 'NumberI':
		if (!validNumber(es, true)) return;
		break;
	case 'NumberD':
		if (!validNumber(es, false)) return;
		// convert decimal separator
		value = value.replace(String.fromCharCode(DECIMAL_SEPARATOR), ".");
		break;
	case 'ADCLow':
	case 'ADCHigh':
		if (!validNumber(es, false)) return;
		break;
	case 'String':
		// allow empty strings
		if (!validString(es, true)) return;
		// trim white space
		value = value.trim();
		break;
	case 'StringF':
		// disallow empty strings
		if (!validString(es, false)) return;
		// trim white space
		value = value.trim();
		break;
	case 'IP':
		if (!validIP(es)) return;
		break;
	case 'Time':
		if (!validTime(es)) return;
		break;
	case 'TimeOffset':
		value = validTimeOffset(es);
		if (isNaN(value)) return;
		value = value.toString();
		break;
	case 'Hostname':
		if (!validHostname(es)) return;
		break;
	}
	
	closeEdit();

	// adc edit mode ?
	switch (editType)
	{
	case 'ADCLow':
		adcLowValue = value;
		adcLowValueLive = document.getElementById('editvalue').innerHTML;
		editValue(editPinId.toString(), 'ADCHigh');
		break;
	case 'ADCHigh':
		adcHighValue = value;
		adcHighValueLive = document.getElementById('editvalue').innerHTML;
		editValue(editPinId.toString(), 'ADCConfirm');
		break;

	default:
		try
		{
			setValue(EDIT_MODE_VALUE, editPinId, urlEncode(value));
		}
		catch (e) {};
		break;
	}
}

// routine to toggle digout
function toggleDigout(index)
{
	// trap text highlighting
	if (isTextHighlighted())
		return;

	try
	{
		setValue(EDIT_MODE_VALUE, editPinId, index);
	}
	catch (e) {};
}

// create modal digout edit
function editDigout(itemId)
{
	// trap text highlighting
	if (isTextHighlighted())
		return;

	editDomId = itemId;
	editPinId = parseInt(itemId, 10);

	var mw = document.getElementById('modalwrapper');
	var mc = document.getElementById('modalcontainer');
	if ((mw === null) || (mc === null))
		return;

	mw.style.height = '11.75em';

	var itemName = document.getElementById(itemId + 'n').innerHTML;
	var itemValue = document.getElementById(itemId + 'v').innerHTML;

	mc.innerHTML = "<div id=\"editheader\"/>";
	var eh = document.getElementById('editheader');
	eh.innerHTML += "<p class=\"editnamel\">" + langStrings.STRING_IDENT_ITEM_NAME + " :</p><p class=\"editname\">" + itemName + "</p>";
	eh.innerHTML += "<p class=\"editvaluel\">" + langStrings.STRING_IDENT_CURRENT_VALUE + " :</p><p id=\"editvalue\" class=\"editvalue\">" + itemValue + "</p>";

	mc.innerHTML += " <div id=\"editdigout\" class=\"editstring\"/>\n";
	var mf = document.getElementById('editdigout');

	for (var i = 1; i <= 6; i++)
		mf.innerHTML += "<a class=\"digout\" onClick=\"toggleDigout(" + i + ");\">" + langStrings.STRING_IDENT_TOGGLE_DIGOUT + i + "</a>";

	mc.innerHTML += "<div id=\"editfooter\"/>\n";
	var ef = document.getElementById('editfooter');
	ef.innerHTML += "<div class=\"editcancel\"><a onClick=\"toggleDigout(-1);closeEdit();\">" + langStrings.STRING_IDENT_CANCEL + "</a></div>\n";

	showEdit();
}

// create modal value edit
function editValue(itemId, type, itemName)
{
	// trap text highlighting
	if (isTextHighlighted())
		return;

	// check for date format
	var dateFormat;
	if (type.substring(0, 4) === 'Date')
	{
		dateFormat = type.substring(4);
		type = 'Date';
	}

	var id = itemId.split("\t");
	var pinId;
	var domId;
	if (id.length == 1)
		pinId = domId = id;
	else
	{
		domId = id[0];
		pinId = id[1];
	}
	editString(domId, pinId, type, itemName);

	// init key handler
	var mf = document.getElementById('textbox');
	if (mf === null)
		return;
	mf.onkeypress = function(event){return keyPress(this, event, type);};

	// init special case validators
	var ae = document.getElementById('accept');
	switch (type)
	{
	case 'NumberI':
		mf.onkeyup = function(event){validNumber(this, true, ae);};
		break;
	case 'NumberD':
	case 'ADCLow':
	case 'ADCHigh':
		mf.onkeyup = function(event){validNumber(this, false, ae);};
		break;
	case 'IP':
		mf.onkeyup = function(event){validIP(this, ae);};
		break;
	case 'Time':
		mf.onkeyup = function(event){validTime(this, ae);};
		break;
	case 'TimeOffset':
		mf.onkeyup = function(event){validTimeOffset(this, ae);};
		break;
	case 'Hostname':
		mf.onkeyup = function(event){validHostname(this, ae);};
		break;
	case 'Date':
		mf.onkeyup = function(event){validDate(this, ae, dateFormat);};
		break;
	case 'String':
	case 'Password':
		mf.onkeyup = function(event){validString(this, true, ae);};
		break;
	case 'StringF':
	case 'PasswordF':
		mf.onkeyup = function(event){validString(this, false, ae);};
		break;
	}
}

// select table option
function selectOption(index)
{
	// trap text highlighting
	if (isTextHighlighted())
		return;

	oe = document.getElementById("option" + index);
	if (oe !== null)
		oe.checked = true;
}

function toggleCheck(index)
{
	// trap text highlighting
	if (isTextHighlighted())
		return;

	ce = document.getElementById("check" + index);
	if (ce !== null)
		ce.checked = !ce.checked;
}

// create modal table edit
function editTable(itemId, itemList, itemName, domId2)
{
	// trap text highlighting
	if (isTextHighlighted())
		return;

	var id = itemId.split("\t");
	var pinId;
	var domId;
	if (id.length == 1)
		pinId = domId = id;
	else
	{
		domId = id[0];
		pinId = id[1];
	}
	editDomId = undefined;
	editPinId = pinId;
	if (domId2 !== undefined)
		domId = domId2;

	var mw = document.getElementById('modalwrapper');
	var mc = document.getElementById('modalcontainer');
	if ((mw === null) || (mc === null))
		return;

	mw.style.height = '30.5em';

	if (itemName === undefined)
	{
		var elName = document.getElementById(domId + 'n');
		if (elName !== null)
			itemName = elName.innerHTML;
	}
	var dve = document.getElementById(domId + 'v');
	var itemValue = null;
	if (dve !== null)
		itemValue = dve.textContent;

	mc.innerHTML = "<div id=\"editheader\"/>";
	var eh = document.getElementById('editheader');
	if (itemName !== undefined)
		eh.innerHTML += "<p class=\"editnamel\">" + langStrings.STRING_IDENT_ITEM_NAME + " :</p><p class=\"editname\">" + itemName + "</p>";
	if (dve !== null)
		eh.innerHTML += "<p class=\"editvaluel\">" + langStrings.STRING_IDENT_CURRENT_VALUE + " :</p><p class=\"editvalue\">" + dve.innerHTML + "</p>";

	mc.innerHTML += " <form id=\"edittable\" class=\"edittable\"/>\n";
	var mf = document.getElementById('edittable');

	var il = itemList.split("\t");
	var selindex = -1;
	for (index = 0; index < (il.length - 1); index += 2)
	{
		var ilThis = il[index];
		var isEnabled = true;
		if (ilThis.substring(0, 1) === "!")
		{
			isEnabled = false;
			ilThis = ilThis.substring(1) + " (Not available)";
		}
		if ((ilThis === itemValue) || (il.length == 2))
			selindex = index;
		if (isEnabled)
			mf.innerHTML += "<p onclick=\"selectOption(" + index + ");\"><input type=\"radio\" name=\"table\" id=\"option" + index + "\" value=\"" + il[index + 1] + "\"/>" + ilThis + "</p></label>";
		else
			mf.innerHTML += "<p><input disabled type=\"radio\" name=\"table\"/>" + ilThis + "</p></label>";
	}

	mc.innerHTML += "<div id=\"editfooter\"/>\n";
	var ef = document.getElementById('editfooter');
	ef.innerHTML += "<div class=\"editaccept\"><a onClick=\"closeTable();\">" + langStrings.STRING_IDENT_APPLY + "</a></div>\n";
	ef.innerHTML += "<div class=\"editcancel\"><a onClick=\"closeEdit();\">" + langStrings.STRING_IDENT_CANCEL + "</a></div>\n";

	selectOption(selindex);

	showEdit();
}

// validate edit table
function closeTable()
{
	// trap text highlighting
	if (isTextHighlighted())
		return;

	// validate selection
	var choice = -1;
	var et = document.forms[0];
	for (index = 0; index < et.elements.length; index++)
	{
		if (et.elements[index].checked)
		{
			choice = index; 
			break;
		}
	}

	// if nothing selected, do nothing
	if (choice === -1)
		return;

	tableElement = et.elements[choice];
	setValue(EDIT_MODE_VALUE, editPinId, et.elements[choice].value);

	closeEdit();
}

// create modal table edit
function editTableCheck(itemId, itemList, itemName)
{
	// trap text highlighting
	if (isTextHighlighted())
		return;

    var mw = document.getElementById('modalwrapper');
    var mc = document.getElementById('modalcontainer');
    if ((mw === null) || (mc === null))
        return;

	var id = itemId.split("\t");
	var pinId;
	var domId;
	if (id.length == 1)
		pinId = domId = id;
	else
	{
		domId = id[0];
		pinId = id[1];
	}

	editDomId = undefined;
    editPinId = pinId;	// set the global so the close function knows what pinid we're editing
    mw.style.height = '30.5em';

	if (itemName === undefined)
	{
		var elName = document.getElementById(domId + 'n');
		if (elName !== null)
			itemName = elName.innerHTML;
	}
    var itemValue = document.getElementById(domId + 'v').innerHTML;
    var itemCheck = document.getElementById(domId + 'c');
    if (itemCheck)
    	itemCheck = parseInt(itemCheck.innerHTML, 10);

    mc.innerHTML = "<div id=\"editheader\"/>";
    var eh = document.getElementById('editheader');
    eh.innerHTML += "<p class=\"editnamel\">" + langStrings.STRING_IDENT_ITEM_NAME + " :</p><p class=\"editname\">" + itemName + "</p>";
    eh.innerHTML += "<p class=\"editvaluel\">" + langStrings.STRING_IDENT_CURRENT_VALUE + " :</p><p class=\"editvalue\">" + itemValue + "</p>";

    mc.innerHTML += " <form id=\"edittable\" class=\"edittable\"/>\n";
    var mf = document.getElementById('edittable');

    var il = itemList.split("\t");
    for (index = 0; index < (il.length - 1); index += 2) {
		var sel = ((itemCheck & (1 << il[index + 1])) != 0);
        mf.innerHTML += "<p onclick=\"toggleCheck(" + index + ");\"><input onclick=\"toggleCheck(" + index + ");\" type=\"checkbox\" name=\"table\" id=\"check" + index + "\" value=\"" + il[index + 1] + "\"" + (sel ? " checked=\"checked\"" : "") +"/>" + il[index] + "</p></label>";
    }

    mc.innerHTML += "<div id=\"editfooter\"/>\n";
    var ef = document.getElementById('editfooter');
    ef.innerHTML += "<div class=\"editaccept\"><a onClick=\"closeTableCheck();\">" + langStrings.STRING_IDENT_APPLY + "</a></div>\n";
    ef.innerHTML += "<div class=\"editcancel\"><a onClick=\"closeEdit();\">" + langStrings.STRING_IDENT_CANCEL + "</a></div>\n";

    showEdit();
}

// validate edit table
function closeTableCheck()
{
	// trap text highlighting
	if (isTextHighlighted())
		return;

	// validate selection
	var selection = 0;
	var et = document.forms[0];
	for (index = 0; index < et.elements.length; index++)
	{
		if (et.elements[index].checked)
			selection |= (1 << et.elements[index].value);
	}

	setValue(EDIT_MODE_VALUE, editPinId, selection);

	closeEdit();
}

// create modal table edit
// send login details
function sendLogin()
{
	var liid = document.getElementById('loginid');
	var liname = document.getElementById('loginname');
	if (liid && liname)
	{
		// populate and submit hidden login value
		document.md5form.username.value = liname.value;
		document.md5form.md5.value = hex_md5(liid.value);
		document.md5form.submit();
	}

	return false;
}

function checkLogin(evt)
{
	var charCode = (evt.which) ? evt.which : evt.keyCode
	if (charCode !== 13)
		return true;

	sendLogin();

	return false;
}

// routine to show confirm dialog
function editConfirm(itemId, action, title)
{
	// trap text highlighting
	if (isTextHighlighted())
		return;

	editDomId = undefined;
	editPinId = parseInt(itemId, 10);

	var mw = document.getElementById('modalwrapper');
	var mc = document.getElementById('modalcontainer');
	if ((mw === null) || (mc === null))
		return;

	mc.innerHTML = "<div id=\"editheader2\"/>\n";
	var eh = document.getElementById('editheader2');
	if (title === undefined)
	{
		mw.style.height = '4em';
		eh.innerHTML = "&nbsp;";
		eh.style.height = '1em';
	}
	else
	{
		mw.style.height = '5.5em';
		eh.innerHTML = "<p class=\"edittitle\">" + title + "</p>";
		eh.style.height = '1.75em';
	}

	mc.innerHTML += "<div id=\"editfooter\"/>\n";
	var ef = document.getElementById('editfooter');
	ef.innerHTML += "<div class=\"editaccept\"><a onClick=\"" + action + "();\">" + langStrings.STRING_IDENT_CONFIRM + "</a></div>\n";
	if (action == 'resetADC')
		ef.innerHTML += "<div class=\"editcancel\"><a onClick=\"setCalMode('" + editPinId + "', 0);closeEdit();\">" + langStrings.STRING_IDENT_CANCEL + "</a></div>\n";

	else
		ef.innerHTML += "<div class=\"editcancel\"><a onClick=\"closeEdit();\">" + langStrings.STRING_IDENT_CANCEL + "</a></div>\n";

	showEdit();
}

// validate reboot confirm
function reboot()
{
	// trap text highlighting
	if (isTextHighlighted())
		return;

	try
	{
		setValue(EDIT_MODE_VALUE, editPinId, 'yes');
		var ef = document.getElementById('editfooter');
		ef.innerHTML = "<p style=\"font-size: 1.5em; text-align: center;\">" + langStrings.STRING_IDENT_REBOOTING + " ...</p>\n";
	}
	catch (e) {};
	
	closeEdit();
}

// validate user delete confirm
function userDelete()
{
	// trap text highlighting
	if (isTextHighlighted())
		return;

	try
	{
		var ue = document.getElementById('u' + editPinId + 'n');
		setValue(SYSTEM_SHOW_USER_DELETE, ue.innerHTML, ue.innerHTML);
	}
	catch (e) {};
	
	closeEdit();
}

// validate user edit
function closeUser()
{
	// trap text highlighting
	if (isTextHighlighted())
		return;

	var ne = document.getElementById('newname');
	var le = document.getElementById('newlevel');
	var pe = document.getElementById('newpwd');
	var pe2 = document.getElementById('newpwd2');

	if (editType === 'userAdd')
	{
		try
		{
			setValue(SYSTEM_SHOW_USER_ADD, ne.value, le.value + ':' + hex_md5(pe.value));
		}
		catch (e) {};
	}
	else if (editType === 'userEdit')
	{
		var one = document.getElementById(editPinId + 'n');
		var level = one.getAttribute('level');
		// check for name change
		if (ne.value !== one.innerHTML)
		{
			try
			{
				setValue(SYSTEM_SHOW_USER_EDIT_NAME, one.innerHTML, ne.value);
			}
			catch (e) {};
		}
		// check for level change
		if (le.value !== level)
		{
			try
			{
				setValue(SYSTEM_SHOW_USER_EDIT_LEVEL, one.innerHTML, le.value);
			}
			catch (e) {};
		}
		// check for password change
		if (pe.value.length > 0)
		{
			try
			{
				setValue(SYSTEM_SHOW_USER_EDIT_PWD, one.innerHTML, hex_md5(pe.value));
			}
			catch (e) {};
		}
	}
	
	closeEdit();
}

// create modal user edit
function editUser(itemId, action, userlist)
{
	// trap text highlighting
	if (isTextHighlighted())
		return;

	var mw = document.getElementById('modalwrapper');
	var mc = document.getElementById('modalcontainer');
	if ((mw === null) || (mc === null))
		return;

	mw.style.height = '17.5em';

	mc.innerHTML = "<div id=\"editheader\"/>";
	var eh = document.getElementById('editheader');

	editDomId = undefined;
	editPinId = itemId;

	// are we adding a new user ?
	if (action === 'add')
	{
		editType = 'userAdd';

		eh.innerHTML += "<p class=\"edittitle\">" + langStrings.STRING_IDENT_ADD_NEW_USER + " ...</p>";

		mc.innerHTML += " <form id=\"edituser\" class=\"edituser\"/>\n";
		var mf = document.getElementById('edituser');
		mf.innerHTML += "<div class=\"edituserl\" id=\"usernamel\">" + langStrings.STRING_IDENT_USERNAME + " :</div><input id=\"newname\" maxlength=\"16\" type=\"text\"/>";

		mf.innerHTML += "<div class=\"edituserl\">Level :</div><select id=\"newlevel\"/>";
		var nl = document.getElementById('newlevel');
		var ul = userlist.split("\t");
		for (var index = 0; index < (ul.length - 1); index += 2)
			nl.options[nl.length] = new Option(ul[index], ul[index + 1], index === (ul.length - 2), false);

		mf.innerHTML += "<div class=\"edituserl\">" + langStrings.STRING_IDENT_PASSWORD + " :</div><input id=\"newpwd\" maxlength=\"32\" type=\"password\"/>";
		mf.innerHTML += "<div class=\"edituserl\" id=\"passwordl\">" + langStrings.STRING_IDENT_CONFIRM_PASSWORD + " :</div><input id=\"newpwd2\" maxlength=\"32\" type=\"password\"/>";

		mc.innerHTML += "<div id=\"editfooter\"/>\n";
		var ef = document.getElementById('editfooter');
		ef.innerHTML += "<div id=\"accept\" class=\"editacceptgrey\"><a onClick=\"closeUser();\">" + langStrings.STRING_IDENT_ADD + "</a></div>\n";
		ef.innerHTML += "<div class=\"editcancel\"><a onClick=\"closeEdit();\">" + langStrings.STRING_IDENT_CANCEL + "</a></div>\n";

		showEdit();
	}
	else if (action === 'edit')
	{
		editType = 'userEdit';

		var one = document.getElementById(itemId + 'n');
		var userlevel = one.getAttribute('level');
		var userdelete = one.getAttribute('delete') === "yes";

		eh.innerHTML += "<p class=\"edittitle\">" + langStrings.STRING_IDENT_EDIT_USER + " ...</p>";

		mc.innerHTML += " <form id=\"edituser\" class=\"edituser\"/>\n";
		var mf = document.getElementById('edituser');
		mf.innerHTML += "<div class=\"edituserl\" id=\"usernamel\">" + langStrings.STRING_IDENT_USERNAME + " :</div><input id=\"newname\" maxlength=\"16\" type=\"text\"/>";

		mf.innerHTML += "<div class=\"edituserl\">" + langStrings.STRING_IDENT_LEVEL + " :</div><select id=\"newlevel\"/>";
		var nl = document.getElementById('newlevel');
		var ul = userlist.split("\t");
		for (var index = 0; index < (ul.length - 1); index += 2)
			nl.options[nl.length] = new Option(ul[index], ul[index + 1], ul[index + 1] == userlevel, false);

		// disable level select ?
		// piggy-back on the "delete" attribute ...
		// if you have permission to delete the user, you clearly have permission to change the level !!
		if (userdelete === null)
			nl.disabled = true;

		mf.innerHTML += "<div class=\"edituserl\">" + langStrings.STRING_IDENT_PASSWORD + " :</div><input id=\"newpwd\" maxlength=\"32\" type=\"password\"/>";
		mf.innerHTML += "<div class=\"edituserl\" id=\"passwordl\">" + langStrings.STRING_IDENT_CONFIRM_PASSWORD + " :</div><input id=\"newpwd2\" maxlength=\"32\" type=\"password\"/>";

		mc.innerHTML += "<div id=\"editfooter\"/>\n";
		var ef = document.getElementById('editfooter');
		ef.innerHTML += "<div id=\"accept\" class=\"editaccept\"><a onClick=\"closeUser();\">" + langStrings.STRING_IDENT_APPLY + "</a></div>\n";
		if (userdelete)
			ef.innerHTML += "<div id=\"delete\" class=\"editdelete\"><a onClick=\"closeEdit(); editConfirm(" + itemId.substring(1) + ", 'userDelete', '" + langStrings.STRING_IDENT_DELETE_USER + "')\">Delete</a></div>\n";
		ef.innerHTML += "<div class=\"editcancel\"><a onClick=\"closeEdit();\">" + langStrings.STRING_IDENT_CANCEL + "</a></div>\n";

		showEdit();

		document.getElementById('newname').value = one.innerHTML;
	}
	else
		return;

	// init key handlers and validators
	var ae = document.getElementById('accept');
	var mf = document.getElementById('newname');
	mf.focus();
	mf.onkeypress = function(event){return keyPress(this, event, 'Username');};
	mf.onkeyup = function(event){validUser(this, ae);};

	mf = document.getElementById('newlevel');
	mf.onkeypress = function(event){return keyPress(this, event, 'Userlevel');};

	mf = document.getElementById('newpwd');
	mf.onkeypress = function(event){return keyPress(this, event, 'Password');};
	mf.onkeyup = function(event){validUser(this, ae);};

	mf = document.getElementById('newpwd2');
	mf.onkeypress = function(event){return keyPress(this, event, 'Password2');};
	mf.onkeyup = function(event){validUser(this, ae);};
}

// routine to set/clear calibrate mode
function setCalMode(id, index)
{
	// trap text highlighting
	if (isTextHighlighted())
		return;

	try
	{
		setValue(SYSTEM_SHOW_INFO_ADCS1, -id, index);
	}
	catch (e) {};
}


// set new adc calibration values
function closeADC()
{
	// trap text highlighting
	if (isTextHighlighted())
		return;

	if ((adcLowValue != -1) && (adcHighValue != -1))
	{
		try
		{
			setValue(SYSTEM_SHOW_INFO_ADCS1, editPinId, adcLowValue + "," + adcLowValueLive + "," + adcHighValue + "," + adcHighValueLive);
		}
		catch (e) {};
	}
	
	setCalMode(editPinId, 0);	// clear calibrate mode
	closeEdit();
}

function resetADC()
{
	// trap text highlighting
	if (isTextHighlighted())
		return;

	try
	{
		setValue(SYSTEM_SHOW_INFO_ADCS1, editPinId, "-1,-1,-1,-1");
	}
	catch (e) {};
	
	setCalMode(editPinId, 0);	// clear calibrate mode
	closeEdit();
}

function resetLog()
{
	// trap text highlighting
	if (isTextHighlighted())
		return;

	try
	{
		setValue(SYSTEM_SHOW_METROLOGY_EVENT_LOG, editPinId, "1");
	}
	catch (e) {};
	
	closeEdit();
}

function resetPorts()
{
	// trap text highlighting
	if (isTextHighlighted())
		return;

	try
	{
		setValue(EDIT_MODE_VALUE, editPinId, "1");
	}
	catch (e) {};
	
	closeEdit();
}

// routine to toggle panel colours
function togglePanel(panel)
{
	// trap text highlighting
	if (isTextHighlighted())
		return;

	// create attribute if needed
	if (panel.hasAttribute('active') === false)
		panel.setAttribute('active', 'false');

	// if panel unselected
	if (panel.getAttribute('active') === 'false')
	{
		// make sure we have some new colours
		if (panel.hasAttribute('toggle'))
		{
			var attr = panel.getAttribute('toggle');
			var colours = attr.split(' ');
			panel.style.backgroundColor = colours[0];
			panel.style.color = colours[1];
		}
		panel.setAttribute('active', 'true');
	}
	else
	{
		panel.style.backgroundColor = 'rgb(204, 204, 204)';
		panel.style.color = 'rgb(128, 128, 128)';
		panel.setAttribute('active', 'false');
	}
}

function ftpTest()
{
	// trap text highlighting
	if (isTextHighlighted())
		return;

	var mw = document.getElementById('modalwrapper');
	var mc = document.getElementById('modalcontainer');
	if ((mw === null) || (mc === null))
		return;

	mc.innerHTML = "<div id=\"editheader2\"/>\n";
	var eh = document.getElementById('editheader2');
	mw.style.height = '30.5em';
	eh.innerHTML = "<p class=\"edittitle\">" + langStrings.STRING_IDENT_FTP_TEST + "</p>";
	eh.style.height = '1.75em';

	mc.innerHTML += "<div id=\"ftplog\"><pre id=\"ftplogtext\">" + langStrings.STRING_IDENT_SENDING_TEST_FILE + " ...\n</pre></div>\n";

	mc.innerHTML += "<div id=\"editfooter\"/>\n";
	var ef = document.getElementById('editfooter');
	ef.innerHTML += "<div class=\"editcancel\"><a onClick=\"closeEdit();\">" + langStrings.STRING_IDENT_CLOSE + "</a></div>\n";

	showEdit();

	try
	{
		setValue(EDIT_MODE_VALUE, NFBSYSINFO_FTP_TEST, "yes");
	}
	catch (e) {};
}

////////////////////////////////////////////////////////////////////////////////
// spool file handling

function toggleSpool(index)
{
	// trap text highlighting
	if (isTextHighlighted())
		return;

	// find all spool files for this id
	var els = document.querySelectorAll('[id^=spool' + index + '_]');
	if (els.length == 0)
		return;

	// is first element hidden ?
	var hidden = els[0].style.display == "none";
	
	// update header item
	var hi = document.getElementById('spool' + index);
	if (hi !== null)
		hi.className = hidden ? "menu expand" : "menu";
	
	// update spool items
	var ns = hidden ? "list-item" : "none";
	for (var i = 0; i < els.length; i++)
		els[i].style.display = ns;
	
	// update spool hash
	if (index < 32)
	{
		if (hidden)
			nSpoolHash |= (1 << index);
		else
			nSpoolHash &= ~(1 << index);
	}
}

////////////////////////////////////////////////////////////////////////////////

// set inactivity timeout value (ms)
var nLogoutInterval = 300 * 1000;

function logout()
{
	// set logout flag
	doLogout = true;
}

var xmlHttpMenu;
function httpStateChangeMenu()
{
	if (xmlHttpMenu.readyState === 4)
	{
		// if we got a reply ...
		if (xmlHttpMenu.responseText !== '')
		{
			var me = document.getElementById('update');
			if (me !== null)
			{
				// update list/header hash values ?
				var dd = xmlHttpMenu.responseText.split("\v");

				// extract new menu hash value
				var hv = dd[0].split(",");
				nListHash = parseInt(hv[0], 10);

				// html stored at index 1
				me.innerHTML = dd[1];

				// restore spool config ?
				if (nSpoolHash != 0)
				{
					for (var i = 0; i < 32; i++)
					{
						if (nSpoolHash & (1 << i))
							toggleSpool(i);
					}
				}
			}
		}
	}
	delete xmlHttpMenu;
}

var xmlHttpHeader;
function httpStateChangeHeader()
{
	if (xmlHttpHeader.readyState === 4)
	{
		// if we got a reply ...
		if (xmlHttpHeader.responseText !== '')
		{
			var he = document.getElementById('nanoinfo');
			if (he !== null)
			{
				// update list/header hash values ?
				var dd = xmlHttpHeader.responseText.split("\v");

				// extract new header hash value
				var hv = dd[0].split(",");
				if (hv.length == 2)
					nHeaderHash = parseInt(hv[1], 10);

				// html stored at index 1
				he.innerHTML = dd[1];
			}
		}
	}
	delete xmlHttpHeader;
}

function updateMenu(bIsHeader)
{
	if (bIsHeader === undefined)
	{
		// close any open edit dialog
		closeEdit();
	}

	// create setvalue ajax request
	var xmlHttpRequest;
	try
	{
		// Firefox, Opera 8.0+, Safari
		xmlHttpRequest = new XMLHttpRequest();
	} 
	catch (e1)
	{
		// Internet Explorer
		try 
		{
			xmlHttpRequest = new ActiveXObject("Msxml2.XMLHTTP");
		} 
		catch (e2)
		{
			try {
				xmlHttpRequest = new ActiveXObject("Microsoft.XMLHTTP");
			} catch (e3)
			{
				alert("Your browser does not support AJAX!");
				return;
			}
		}
	}
	if (bIsHeader === undefined)
	{
		xmlHttpMenu = xmlHttpRequest;
		xmlHttpMenu.onreadystatechange = httpStateChangeMenu;
	}
	else
	{
		xmlHttpHeader = xmlHttpRequest;
		xmlHttpHeader.onreadystatechange = httpStateChangeHeader;
	}

	// set the cookies
	document.cookie = "id" + SYSID + "=" + LoginId;

	if (bIsHeader === undefined)
	{
		// send request
		xmlHttpMenu.open("POST", "/cgi-bin/web.fcgi?fn=3&" + window.location.search.substring(1), true);
		xmlHttpMenu.send("1");
		// reset hash value
		nListHash = -1;
	}
	else
	{
		// send request
		xmlHttpHeader.open("POST", "/cgi-bin/web.fcgi?fn=4&" + window.location.search.substring(1), true);
		xmlHttpHeader.send("1");
		// reset hash value
		nHeaderHash = -1;
	}
}

var xmlHttpSet;
var oldInnerHTML = '';

function httpStateChangeSet()
{
	if (xmlHttpSet.readyState === 4)
	{
		// if we got a reply ...
		if (xmlHttpSet.responseText !== '')
		{
			var rv = xmlHttpSet.responseText.split("\t");
			if (rv[0] === 'fail')
			{
				var bUpdateHeader = false;
				
				switch (parseInt(rv[1], 10))
				{
				case EDIT_MODE_ACCEPT:	// accept
					// create info message
					var et = document.getElementById('EditTable');
					et.innerHTML = '<div style="position: absolute; visibility: visible; left: 0px; top: 32px; height: 100px; width: 458px; color: #ff0000; font: 28px DejaVu Sans Bold, Verdana Bold; text-align: center;">' + rv[2] + '</div>';
					break;

				case EDIT_MODE_USER_NAME:	// edit username
				case EDIT_MODE_USER_DELETE:	// delete user
					// create info message
					var et = document.getElementById('EditUser');
					oldInnerHTML = et.innerHTML;
					et.innerHTML = '<div style="position: absolute; visibility: visible; left: 0px; top: 32px; height: 100px; width: 458px; color: #ff0000; font: 28px DejaVu Sans Bold, Verdana Bold; text-align: center;">' + rv[2] + '</div>';
					// cancel cursor flash
					stopCursor('NewUserValue', 'CursorU');
					break;

				case EDIT_MODE_USER_PWD:	// edit username
					// set new header
					document.getElementById('NewUserHeader').innerHTML = sysStrings[STRING_IDENT_ENTER_PASSWORD];
					// set edit mode
					nEditMode = EDIT_MODE_USER_PWD;
					bUpdateHeader = true;
					break;

				case EDIT_MODE_USERADD_NAME:
					// set current header
					document.getElementById('OldUserHeader').innerHTML = sysStrings[STRING_IDENT_ADD_NEW_USER];
					// set new header
					document.getElementById('NewUserHeader').innerHTML = sysStrings[STRING_IDENT_ENTER_USERNAME];
					// set edit mode
					nEditMode = EDIT_MODE_USERADD_NAME;
					bUpdateHeader = true;
					break;

				case SYSTEM_SHOW_INFO_ADCS1:
					nEditMod = SYSTEM_SHOW_INFO_ADCS1;
					break;

				default:
					// reset edit mode
					nEditMode = EDIT_MODE_NONE;
					break;
				}

				// update header div ?
				if (bUpdateHeader)
				{
					// show error message
					document.getElementById('OldUserValue').innerHTML = rv[2];
					// clean new value
					var nv = document.getElementById('NewUserValue');
					nv.innerHTML = '';
					// move cursor
					document.getElementById('CursorU').style.left = parseInt(nv.style.left, 10) + cursorOffset;
				}
			}
			else if (rv[0] === 'pass')
			{
				switch (parseInt(rv[1], 10))
				{
				case EDIT_MODE_USER_NAME:	// edit username
				case EDIT_MODE_USERADD_NAME:	// add user
				case EDIT_MODE_USER_DELETE:	// delete user
					// cancel cursor flash
					stopCursor('EditUser', 'CursorU');
					// reload page to show updated user list
					updateMenu();
					break;

				case NFBSYSINFO_NET_DHCP1:
				case NFBSYSINFO_NET_DHCP2:
					// update setting
					var bIsDhcp = false;
					if ((tableElement.value == 'DHCP') ||
						(tableElement.value == 'Off'))
						bIsDhcp = true;
					var nColour = bIsDhcp ? '#808080' : '#246BB2';
					var newStyle = bIsDhcp ? "hidden" : "visible";
					var newCursor = bIsDhcp ? "default" : "pointer";
					var ne = document.getElementById(editPinId + 'v');
					ne.innerHTML = tableElement.value;
					ne.style.color = '#cc0000';
					// change element colours, cursor, etc for the other network settings of this port
					switch (parseInt(editPinId, 10))
					{
					case NFBSYSINFO_NET_DHCP1:
						// change ip
						ne = document.getElementById(NFBSYSINFO_NET_IP1 + 'v');
						ne.style.color = nColour;
						ne.nextElementSibling.style.visibility = newStyle;
						ne = ne.parentNode;
						if (bIsDhcp)
							ne.onclick = undefined;
						else
							ne.onclick = function() {editValue(NFBSYSINFO_NET_IP1.toString(), 'IP');}
						ne.style.cursor = newCursor;
						// change netmask
						ne = document.getElementById(NFBSYSINFO_NET_NETMASK1 + 'v');
						ne.style.color = nColour;
						ne.nextElementSibling.style.visibility = newStyle;
						ne = ne.parentNode;
						if (bIsDhcp)
							ne.onclick = undefined;
						else
							ne.onclick = function() {editValue(NFBSYSINFO_NET_NETMASK1.toString(), 'IP');}
						ne.style.cursor = newCursor;
						// change gateway
						ne = document.getElementById(NFBSYSINFO_NET_GATEWAY1 + 'v');
						ne.style.color = nColour;
						ne.nextElementSibling.style.visibility = newStyle;
						ne = ne.parentNode;
						if (bIsDhcp)
							ne.onclick = undefined;
						else
							ne.onclick = function() {editValue(NFBSYSINFO_NET_GATEWAY1.toString(), 'IP');}
						ne.style.cursor = newCursor;
						break;
					case NFBSYSINFO_NET_DHCP2:
						// change ip
						ne = document.getElementById(NFBSYSINFO_NET_IP2 + 'v');
						ne.style.color = nColour;
						// change netmask
						ne = document.getElementById(NFBSYSINFO_NET_NETMASK2 + 'v');
						ne.style.color = nColour;
						break;
					}
					break;

				case NFBSYSINFO_NET_IP1:
				case NFBSYSINFO_NET_IP2:
				case NFBSYSINFO_NET_NETMASK1:
				case NFBSYSINFO_NET_NETMASK2:
				case NFBSYSINFO_NET_GATEWAY1:
					var es = document.getElementById('textbox');
					var ne = document.getElementById(editPinId + 'v');
					if ((es === undefined) || (ne == undefined))
						break;
					ne.innerHTML = es.value;
					ne.style.color = '#cc0000';
					break;

				case NFBSYSINFO_NET_ACCEPT:
					// show 10 sec timer window
					showTimer(10, updateMenu);
					break;

				case NFBSYSINFO_PRINTER1_TRANSPORT:
				case NFBSYSINFO_PRINTER2_TRANSPORT:
				case NFBSYSINFO_PRINTER3_TRANSPORT:
				case SYSTEM_SHOW_USER_ADD:
				case SYSTEM_SHOW_USER_DELETE:
				case SYSTEM_SHOW_USER_EDIT_NAME:
				case SYSTEM_SHOW_USER_EDIT_LEVEL:
				case SYSTEM_SHOW_SPOOL:
					// reload page to show updated settings
					updateMenu();
					break;

				case NFBSYSINFO_HOSTNAME:
					document.getElementById(NFBSYSINFO_HOSTNAME + 'v').innerHTML = document.getElementById('textbox').value;
					break;

				case EDIT_MODE_PRINTER_FLOW:	// edit printer flow control mode
					// update flow control mode
					var tvi = document.getElementById('Table' + listTableIndex + 't').innerHTML;
					document.getElementById('List' + listIndex + 'ptr').innerHTML = tvi;
					break;

				case EDIT_MODE_PRINTER_ADDR:	// edit printer address
				case EDIT_MODE_PRINTER_PORT:	// edit printer param
					// update setting
					document.getElementById('List' + listIndex + 'ptr').innerHTML = document.getElementById('NewValue').innerHTML;
					break;

				case EDIT_MODE_DIGOUTS:	// edit digouts
					// update manual digout value
					var nv = document.getElementById('NewValue');
					var nvi = nv.innerHTML;
					var id = parseInt(rv[2], 10);
					nv.innerHTML = nvi.substring(0, id) + rv[3].substring(0, 1) + nvi.substring(id + 1);
					break;					

				case EDIT_MODE_TIME_OFFSET:	// time offset
					// update time offset
					document.getElementById('List' + listIndex + 'to').innerHTML = document.getElementById('NewTimeOffset').innerHTML;
					break;

				case EDIT_MODE_DATE_FORMAT:	// date format
					// update date format
					var tvi = document.getElementById('Table' + listTableIndex + 't').innerHTML;
					document.getElementById('List' + listIndex + 'df').innerHTML = tvi;
					break;

				case EDIT_MODE_USER_PWD:	// edit password
				case EDIT_MODE_USER_LEVEL:	// edit level
					// hide edit div
					document.getElementById('EditUser').style.visibility = 'hidden';
					nEditMode = EDIT_MODE_NONE;
					// cancel cursor flash
					stopCursor('EditUser', 'CursorU');
					// restore softkeys
					restoreSoftKeys();
					break;

				case NFBSYSINFO_FTP_TEST:
					var fl = document.getElementById('ftplogtext');
					if (fl !== null)
						fl.innerHTML += rv[3];
					break;

				default:
					// reset edit mode
					nEditMode = EDIT_MODE_NONE;
					break;
				}
			}
		}
	}
	delete xmlHttpSet;
}

function setLocation(value)
{
	// trap text highlighting
	if (isTextHighlighted())
		return;

	location.href = value;
}

function setValue(type, index, value, div)
{
	// trap text highlighting
	if (isTextHighlighted())
		return;

	resetTimeout();
	
	// create setvalue ajax request
	try
	{
		// Firefox, Opera 8.0+, Safari
		xmlHttpSet = new XMLHttpRequest();
	} 
	catch (e1)
	{
		// Internet Explorer
		try 
		{
			xmlHttpSet = new ActiveXObject("Msxml2.XMLHTTP");
		} 
		catch (e2)
		{
			try {
				xmlHttpSet = new ActiveXObject("Microsoft.XMLHTTP");
			} catch (e3)
			{
				alert("Your browser does not support AJAX!");
				return;
			}
		}
	}
	xmlHttpSet.onreadystatechange = httpStateChangeSet;

	// set the cookies
	document.cookie = "id" + SYSID + "=" + LoginId;

	var postMsg = "/cgi-bin/web.fcgi?fn=2&id=" + type + "," + index + "," + value;

	// send extra toggle info ?
	if (div != undefined)
	{
		var parent = div.parentElement;
		var divlist = parent.children;
		var refArray = [];
		for (var i = 0; i < divlist.length; i++)
		{
			var child = divlist[i];
			if (child.hasAttribute('active') &&
				(child.getAttribute('active') === 'true') &&
				child.hasAttribute('bit') && 
				child.hasAttribute('ref'))
			{
				var bit = parseInt(child.getAttribute('bit'), 10);
				refArray[bit] = child.getAttribute('ref');
			}
		}
		for (var i = 0; i < refArray.length; i++)
		{
			if (refArray[i] !== undefined)
				postMsg += "," + refArray[i];
		}
	}

	xmlHttpSet.open("POST", postMsg, true);
	xmlHttpSet.send("1");
}

function setHeaderValues(request, ids)
{
	requestStringHeader = request;
	idArrayHeader = ids.split("\t");

	requestString = requestStringHeader + "," + requestStringMain;
	idArray = idArrayHeader.concat(idArrayMain);
}

function setMainValues(request, ids)
{
	requestStringMain = request;
	idArrayMain = ids.split("\t");

	requestString = requestStringHeader + "," + requestStringMain;
	idArray = idArrayHeader.concat(idArrayMain);
}

function flashAlarmActive()
{
	var aid = document.getElementById('nanoalarm');
	if (aid === null)
		return;

	if (aid.className === 'clear')
	{
		aid.className = 'active';
	}
	else
	{
		aid.className = 'clear';
	}
}

var commsTimeout = 0;
var xmlHttpGet = null;
var xmlTimeoutGetId = null;

function httpTimeoutGet()
{
	xmlHttpGet.abort();
	delete xmlHttpGet;
	bGotReply = true;
	bGotTimeout = true;
}

function getLiveADCValue(v)
{
	// remove possible "default" marker
	// do a reverse scan for a space then go from there
	var idx = v.lastIndexOf(" ");
	if (idx != -1)
		v = v.substring(idx);
	return v;
}

function httpStateChangeGet()
{
	if (xmlHttpGet.readyState === 4)
	{
		bGotReply = true;

		// if we got a timeout ...
		if (xmlHttpGet.responseText === '')
		{
			// increment comms timeout
			if (++commsTimeout >= 5)
			{
				var mw = document.getElementById('modalwrapper');
				var mc = document.getElementById('modalcontainer');
				if ((mw === null) || (mc === null))
					return;

				mw.style.height = '17.5em';
				mc.style.borderColor = '#802020';
				mc.style.height = 'inherit';
				mc.innerHTML = "<div id=\"timeout\">" + langStrings.STRING_IDENT_CONNECTION_TIMEOUT + " ...</div>";

				showEdit();

				//document.getElementById('container').innerHTML = '';
				return;
			}
		}
		// display the new values ...
		else
		{
			// reset comms timeout count
			commsTimeout = 0;

			// did we get a "logout" message
			if (xmlHttpGet.responseText === 'logout\n')
			{
				doLogout = true;
			}
			else
			{
				var nReplyIndex = 0;
				var getReply = xmlHttpGet.responseText.split("\x1b");
				var ss = getReply[0].split("\t");
				var rv = getReply[1].split("\t");

				// update alarm status
				switch (ss[0].substring(0, 1))
				{
				case 'U':
					// if not already flashing the button ...
					if (bAlarmFlashing === false)
					{
						// flash alarm active button
						bAlarmFlashing = true;
						document.getElementById('nanoalarm').className = 'active';
						flashAlarmId = setInterval("flashAlarmActive()", 500);
					}
					break;

				case 'A':
					// show steady alarm active button
					clearInterval(flashAlarmId);
					document.getElementById('nanoalarm').className = 'active';
					bAlarmFlashing = false;
					break;

				case 'C':
					// show clear alarm button
					clearInterval(flashAlarmId);
					document.getElementById('nanoalarm').className = 'clear';
					bAlarmFlashing = false;
					break;
				}

				// update printer status
				var nSysAlarmStatus = parseInt(ss[1], 10);
				var nPrintErr = nSysAlarmStatus & (ALARM_ID_ALL_PRINTERS | ALARM_ID_SPOOL_FULL);
				var pe = document.getElementById('printer-error');
				if (pe !== null)
					pe.style.visibility = (nPrintErr == 0) ? 'hidden' : 'visible';
				pe = document.getElementById('printer');
				if (pe !== null)
					pe.style.visibility = (nPrintErr != 0) ? 'hidden' : 'visible';

				// extract each value pair
				for (nReplyIndex = 0; nReplyIndex < idArray.length; nReplyIndex++)
				{
					// user info ?
					if (idArray[nReplyIndex] === 'User')
					{
						var liform = document.getElementById('loginform');
						if (liform === null)
							continue;

						// no-one is currently logged in
						if (rv[nReplyIndex] === '<NULL>')
						{
							// if the login is currently hidden ...
							if (liform.style.visibility == 'hidden')
							{
								document.getElementById('lockimg').style.visibility = 'hidden';
								liform.style.visibility = 'visible';
								// update login text
								var litid = document.getElementById('logintext');
								if (litid)
									litid.innerHTML = langStrings.STRING_IDENT_ENTER_LOGIN_ID;

								var cur = document.getElementById('CursorL');
								// init login text
								document.getElementById('loginname').focus();
								document.getElementById('loginid').value = '';
								LoginId = '';

								// set edit mode
								nEditMode = EDIT_MODE_LOGIN;
							}
						}
						else
						{
							// if the login is currently visible ...
							if (liform.style.visibility == 'visible')
							{
								var lili = document.getElementById('lockimg');
								lili.style.visibility = 'visible';
								lili.focus();
								liform.style.visibility = 'hidden';
								// set edit mode
								nEditMode = EDIT_MODE_LOGGED_IN;

								// update login text
								var litid = document.getElementById('logintext');
								if (litid)
									litid.innerHTML = langStrings.STRING_IDENT_TOO_MANY_USERS;
							}
						}
					}
					// list/header hash info ?
					else if (idArray[nReplyIndex] === 'ActiveHash')
					{
						var dd = rv[nReplyIndex].split(",");
						// check list hash
						var nNewHash = parseInt(dd[0], 10);
						if (nListHash === -1)
						{
							nListHash = nNewHash;
						}
						else if (nNewHash != nListHash)
						{
							// reload menu
							updateMenu();
							// hash changed, so ignore all other reply values
							break;
						}
						// check header hash
						if (dd.length == 2)
						{
							nNewHash = parseInt(dd[1], 10);
							if (nHeaderHash === -1)
							{
								nHeaderHash = nNewHash;
							}
							else if (nNewHash != nHeaderHash)
							{
								// reload header
								updateMenu(true);
								// hash changed, so ignore all other reply values
								break;
							}
						}
					}
					// ndb info ?
					else if (idArray[nReplyIndex] === 'NDBInfo')
					{
						var dd = rv[nReplyIndex].split(",");
						if (dd.length < 7)
							break;
						var maxCoord = 0;
						var isOutside = false;

						// extract (x, y) pairs
						var xArray = [0, 0, 0, 0];
						var yArray = [0, 0, 0, 0];
						for (var i = 0, j = 0, marker = 5; i <= 3; i++, marker++)
						{
							var x = parseFloat(dd[j++]);
							var y = (i == 3) ? 0 : parseFloat(dd[j++]);
							var ax = Math.abs(x);
							var ay = Math.abs(y);
							if ((ax > 1.0) || (ay > 1.0))
								isOutside = true;
							if (ax > Math.abs(maxCoord))
								maxCoord = ax;
							if (ay > Math.abs(maxCoord))
								maxCoord = ay;
							xArray[i] = x;
							yArray[i] = y;

							// update values
							var ve = document.getElementById('ndbvalue' + marker);
							if (ve !== null)
								ve.innerHTML = ": ( " + x.toFixed(2) + ", " + y.toFixed(2) + " )";
						}


						// calculate new scale
						var maxScale = 2;
						var scale = (maxCoord > 1) ? (5 / maxCoord) : maxScale;
						if (scale > maxScale)
							scale = maxScale;
						else
						{
							scale *= 0.75;
							if (scale < 0.025)
								scale = 0.025;
						}
						var pe = document.getElementById('ndb');
						var ems = parseInt(pe.clientWidth, 10) / 48.0;
						var nde = document.getElementById('ndbdivider5');
						var xCentre = parseInt(nde.offsetLeft, 10) / ems;
						nde = document.getElementById('ndbdivider6');
						var yCentre = parseInt(nde.offsetTop, 10) / ems;
						var unitScale = 10.0 * scale;

						// adjust bounding box
						var bbsize = unitScale - 0.2;
						var bbleft = xCentre - (unitScale / 2) - 0.05;
						var bbtop = yCentre - (unitScale / 2) - 0.05;
						var nbe = document.getElementById('ndbbox');
						nbe.style.width = bbsize + 'em';
						nbe.style.height = bbsize + 'em';
						nbe.style.left = bbleft + 'em';
						nbe.style.top = bbtop + 'em';

						// adjust dividers
						var divsize = bbsize * 3;
						var divleft = xCentre - (unitScale * 1.5);
						var divtop = yCentre - (unitScale * 1.5);
						nde = document.getElementById('ndbdivider1');
						nde.style.left = (bbleft + 0.05).toString() + 'em';
						nde.style.top = divtop + 'em';
						nde.style.height = divsize + 'em';
						nde = document.getElementById('ndbdivider2');
						nde.style.left = (bbleft + bbsize + 0.25).toString() + 'em';
						nde.style.top = divtop + 'em';
						nde.style.height = divsize + 'em';
						nde = document.getElementById('ndbdivider3');
						nde.style.top = (bbtop + 0.05).toString() + 'em';
						nde.style.left = divleft + 'em';
						nde.style.width = divsize + 'em';
						nde = document.getElementById('ndbdivider4');
						nde.style.top = (bbtop + bbsize + 0.25).toString() + 'em';
						nde.style.left = divleft + 'em';
						nde.style.width = divsize + 'em';
						nde = document.getElementById('ndbdivider5');
						nde.style.top = divtop + 'em';
						nde.style.height = divsize + 'em';
						nde = document.getElementById('ndbdivider6');
						nde.style.left = divleft + 'em';
						nde.style.width = divsize + 'em';

						// scale (x, y) coords
						for (var i = 0, marker = 1; i <= 3; i++, marker++)
						{
							var x = xArray[i] * scale;
							var y = yArray[i] * scale;

							x = xCentre + (x * 5);
							if (x < 0) x = 0;
							if (x > 48) x = 48;
							x -= 0.5;

							y = yCentre - (y * 5);
							if (y < 0) y = 0;
							if (y > 40) y = 40;
							y -= 0.5;

							var me = document.getElementById('marker' + marker);
							if (me != null)
							{
								me.style.left = x + 'em';
								me.style.top = y + 'em';
							}
						}

						// anything outside the bounding box ?
						nbe.className = isOutside ? 'error' : '';

						// update DP values
						if (dd.length < 11)
							break;
						var ue = document.getElementById('ndbunits');
						var units = (ue !== null) ? ' ' + ue.innerHTML : '';
						marker = 1;
						for (var i = 7; i <= 10; i++, marker++)
						{
							var ve = document.getElementById('ndbvalue' + marker);
							if (ve !== null)
							{
								var v = parseFloat(dd[i]);
								ve.innerHTML = ': ' + v.toFixed(2) + units;
							}
						}
					}
					else
					{
						var id = document.getElementById(idArray[nReplyIndex]);
						if (id !== null)
						{
							// does this value use an image ?
							var iid = document.getElementById(idArray[nReplyIndex] + 'i');
							if (iid !== null)
							{
								var itv = iid.getAttribute('triggerValue');
								var il = iid.getAttribute('imageList').split("\t");
								// did we hit the trigger ?
								if (itv <= parseFloat(rv[nReplyIndex]))
								{
									iid.style.backgroundImage = "url(" + il[1] + ")";
								}
								else
								{
									iid.style.backgroundImage = "url(" + il[0] + ")";
								}
							}
							else
							{
								// do we need to refresh the screen ?
								if (idArray[nReplyIndex].length > 4)
								{
									var idtemp = idArray[nReplyIndex].substring(0, idArray[nReplyIndex].length - 1);
									var lid = document.getElementById(idtemp);
									var dra = lid ? lid.getAttribute('doRefresh') : 'false';
									if ((dra === 'true') && (id.innerHTML != rv[nReplyIndex]))
									{
										// reload page to show updated items list
										updateMenu();
										break;
									}
								}
								// set the value (only if it's changed)
								if (id.innerHTML !== rv[nReplyIndex])
									id.innerHTML = rv[nReplyIndex];
							}
						}

						// update modal live value (only if it's changed)
						if (editDomId !== undefined)
						{
							var liveItem = document.getElementById(editDomId + 'v');
							var liveValue = document.getElementById('editvalue');
							if ((liveItem !== null) && (liveValue !== null) && (liveValue.innerHTML !== liveItem.innerHTML))
							{
								// are we in ADC calibration mode ?
								switch (nEditMode)
								{
								case SYSTEM_SHOW_INFO_ADCS1:
									liveValue.innerHTML = getLiveADCValue(liveItem.innerHTML);
									break;

								default:
									liveValue.innerHTML = liveItem.innerHTML;
									break;
								}
							}
						}
					}
				}
			}
		}
	}
	delete xmlHttpGet;
}

function getValues()
{
	// has another tab logged out ?
	// if so, force a logout
	var nThisId = parseInt(getCookie("id" + SYSID), 10);
	if ((nThisId == 0) && (LoginId !== ""))
		doLogout = true;

	// if we've got to logout
	if (doLogout)
	{
		// stop getvalue interval
		clearInterval(timerId);
		// force a page reload
		document.location.href = "/cgi-bin/web.fcgi?id=logout";
	}
	else
	{
		// check to see if we've just jumped back into this
		// page by using the browser back button ??
		if ((document.cookie !== '') && !bGotTimeout)
		{
			if ((nThisId !== 0) && (nThisId !== LoginId))
			{
				// stop getvalue interval
				clearInterval(timerId);
				// force a page reload
				document.location.href = "/index.html";
				return;
			}
		}

		// create getvalues ajax request
		try
		{
			// Firefox, Opera 8.0+, Safari
			xmlHttpGet = new XMLHttpRequest();
		} 
		catch (e1)
		{
			// Internet Explorer
			try 
			{
				xmlHttpGet = new ActiveXObject("Msxml2.XMLHTTP");
			} 
			catch (e2)
			{
				try {
					xmlHttpGet = new ActiveXObject("Microsoft.XMLHTTP");
				} catch (e3)
				{
					alert("Your browser does not support AJAX!");
					return;
				}
			}
		}
		xmlHttpGet.onreadystatechange = httpStateChangeGet;

		clearTimeout(xmlTimeoutGetId);
		xmlTimeoutGetId = setTimeout("httpTimeoutGet()", 5000);

		// request new values
		xmlHttpGet.open("POST", "/cgi-bin/web.fcgi?fn=1&id=" + urlEncode(requestString), true);
		xmlHttpGet.send("1");
	}
}

var rebootBar = 0;

// request timer
function requestTimer()
{
	// if we got the reply from the last request
	if (bGotReply === true)
	{
		bGotReply = false;
		getValues();
	}
}

// routine to show "downloading archive" message
var DownloadTimeout = 0;
function startDownload(message)
{
	resetTimeout();

	document.cookie = "dl=; expires=Thu, 1 Jan 1970 00:00:00 GMT";
	DownloadTimeout = setInterval("checkDownload()", 500);

	var mw = document.getElementById('modalwrapper');
	var mc = document.getElementById('modalcontainer');
	if ((mw === null) || (mc === null))
		return;

	mw.style.height = '7.5em';
	mc.style.height = 'inherit';
	mc.innerHTML = "<div id=\"download\">" + message + " ...</div><div id=\"loader\"></div>";

	showEdit();
}

function checkDownload()
{
	// do we have a dl cookie ?
	var cookieDl = getCookie("dl");
	if (cookieDl === "Done")
	{
		closeEdit();
		clearInterval(DownloadTimeout);
	}
	else if (cookieDl === "Refresh")
	{
		closeEdit();
		clearInterval(DownloadTimeout);
		updateMenu();
	}
}

// Initialization code. 
function initCode(streamId, screenId, listHash, idleTime)
{
	// extract initial hash values
	var dd = listHash.split(",");
	nListHash = parseInt(dd[0], 10);
	if (dd.length == 2)
		nHeaderHash = parseInt(dd[1], 10);

	nScreenId = screenId;
	nStreamId = streamId;
	nLogoutInterval = idleTime * 60000;
	// trap to stop javascript setTimeout() overflow
	if (nLogoutInterval > 2147483647)
		nLogoutInterval = 2147483647;
	else if (nLogoutInterval < 0)
		nLogoutInterval = 0;

	// do we have an id cookie ?
	var cookieId = getCookie("id" + SYSID);
	if (cookieId !== "")
	{
		LoginId = parseInt(cookieId, 10);
		if (LoginId !== 0)
		{
			// init logout timeout
			if (nLogoutInterval != 0)
				LoginTimeout = setTimeout("logout()", nLogoutInterval);
		}
	}

	// are we showing the login page ?
	var liform = document.getElementById('loginform');
	if (liform)
	{
		// init login text
		var liname = document.getElementById('loginname');
		liname.value = '';
		document.getElementById('loginid').value = '';
		LoginId = '';

		// set edit mode
		nEditMode = EDIT_MODE_LOGIN;

		// set focus
		liname.focus();
	}

	if (requestString.length != 0)
	{
		// perform initial getvalues
		getValues();
		// setup periodic update (5 sec on login page, 1 sec elsewhere)
		timerId = setInterval("requestTimer()", nEditMode == EDIT_MODE_LOGIN ? 5000 : 1000);
	}
}

